//
//  DisclaimerView.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

struct DisclaimerView: View {
    @State private var hasAcceptedDisclaimer = false
    @Environment(\.dismiss) private var dismiss
    let onAccept: () -> Void
    
    var body: some View {
        ScrollView {
            VStack(alignment: .leading, spacing: 20) {
                Text("Medical Disclaimer")
                    .font(.headline)
                    .foregroundColor(.red)
                
                VStack(alignment: .leading, spacing: 15) {
                    Text("⚠️ IMPORTANT NOTICE")
                        .font(.subheadline)
                        .fontWeight(.bold)
                        .foregroundColor(.orange)
                    
                    Text("This application is for ENTERTAINMENT and EDUCATIONAL purposes only.")
                        .font(.caption)
                        .fontWeight(.semibold)
                    
                    Text("This app is NOT a medical device and should NOT be used for:")
                        .font(.caption2)
                        .fontWeight(.medium)
                    
                    VStack(alignment: .leading, spacing: 5) {
                        Text("• Medical diagnosis or treatment")
                        Text("• Making healthcare decisions")
                        Text("• Replacing professional medical advice")
                        Text("• Predicting actual life expectancy")
                    }
                    .font(.caption2)
                    .padding(.leading, 10)
                    
                    Text("Always consult with qualified healthcare professionals for medical advice, diagnosis, or treatment.")
                        .font(.caption2)
                        .fontWeight(.medium)
                        .foregroundColor(.blue)
                    
                    Text("The calculations are based on statistical models and population data. Individual results may vary significantly.")
                        .font(.caption2)
                        .italic()
                }
                
                Toggle("I understand and accept this disclaimer", isOn: $hasAcceptedDisclaimer)
                    .font(.caption2)
                
                HStack {
                    Button("Cancel") {
                        dismiss()
                    }
                    .foregroundColor(.red)
                    
                    Spacer()
                    
                    Button("Accept") {
                        UserDefaults.standard.set(true, forKey: "hasAcceptedDisclaimer")
                        onAccept()
                        dismiss()
                    }
                    .disabled(!hasAcceptedDisclaimer)
                    .foregroundColor(hasAcceptedDisclaimer ? .green : .gray)
                }
                .font(.caption)
            }
            .padding()
        }
        .navigationTitle("Disclaimer")
        .navigationBarTitleDisplayMode(.inline)
    }
}

#Preview {
    DisclaimerView {
        print("Disclaimer accepted")
    }
}